#include "Digitizer.h"

void Digitizer::WriteRunHeader(){
  fOutputfile.write(reinterpret_cast<char*>(fDataRunHeader),sizeof(UShort_t)*fRunHeaderbuffer);
};

void Digitizer::WriteRunTrailer(){
  fOutputfile.write(reinterpret_cast<char*>(fDataRunTrailer),sizeof(UShort_t)*fRunTrailerbuffer);
};

void Digitizer::WriteData(){

  // Routine that writes the data to a binary file
  // PSCU data are already swapped
  fOutputfile.write(reinterpret_cast<char*>(fDataPSCU),sizeof(UShort_t)*fPSCUbuffer);
  // TRG
  fOutputfile.write(reinterpret_cast<char*>(fDataTrigger),sizeof(UChar_t)*fTRIGGERbuffer); //30/11/07 SO; it was 153
  // TOF
  fOutputfile.write(reinterpret_cast<char*>(fDataTof),sizeof(UChar_t)*fTOFbuffer);
  // AC
  int n=1000000;
  UShort_t temp[1000000];
  memset(temp,0,sizeof(UShort_t)*n);
  swab(fDataAC,temp,sizeof(UShort_t)*fACbuffer);  // WE MUST SWAP THE BYTES!!!
  fOutputfile.write(reinterpret_cast<char*>(temp),sizeof(UShort_t)*fACbuffer);
  // CALO
  memset(temp,0,sizeof(UShort_t)*n);
  swab(fDataCALO,temp,sizeof(UShort_t)*fCALOlength); // WE MUST SWAP THE BYTES!!!
  fOutputfile.write(reinterpret_cast<char*>(temp),sizeof(UShort_t)*fCALOlength);
  // TRK
  memset(temp,0,sizeof(UShort_t)*n);
  swab(fDataTrack,temp,sizeof(UShort_t)*fTracklength);  // WE MUST SWAP THE BYTES!!!
  fOutputfile.write(reinterpret_cast<char*>(temp),sizeof(UShort_t)*fTracklength); 
  fTracklength=0; 
   // padding to 64 bytes
  //
  if ( fPadding ){
    fOutputfile.write(reinterpret_cast<char*>(fDataPadding),sizeof(UChar_t)*fPadding);
  };
  // S4
  memset(temp,0,sizeof(UShort_t)*n);
  swab(fDataS4,temp,sizeof(UShort_t)*fS4buffer);  // WE MUST SWAP THE BYTES!!!
  fOutputfile.write(reinterpret_cast<char*>(temp),sizeof(UShort_t)*fS4buffer);
  // ND
  memset(temp,0,sizeof(UShort_t)*n);
  swab(fDataND,temp,sizeof(UShort_t)*fNDbuffer);  // WE MUST SWAP THE BYTES!!!
  fOutputfile.write(reinterpret_cast<char*>(temp),sizeof(UShort_t)*fNDbuffer);
};
